<?php


namespace YiYunzhang\Common;

/**
 * Class: Authentication
 * @describe: 鉴权验证类
 * @author: MagicConch17
 * @email: higanbana98@hotmail.com
 * @date: 2020/10/30 13:49
 * @package YiYunzhang\Common
 */
trait Authentication
{
    /** @var array $signatureArray 鉴权的数组 */
    private $signatureArray = [];

    /**
     * Notes: 鉴权方法
     * @param $appKey
     * @param $secret
     * @param array $data
     * @param string $version
     * @return array
     * @date: 2020/10/30 13:59
     * @author: MagicConch17
     */
    private function signature($appKey, $secret, $data = [], $version = '1.0'): array
    {
        $signature = [
            'timestamp' => date('Y-m-d H:i:s', time()),
            'appKey' => $appKey,
            'v' => $version,
            'nonce' => rand(100000, 999999),
        ];

        $signature = array_merge($signature, $data);

        ksort($signature);

        $signatureString = implode('', $signature);
        $signatureString = strtoupper(md5($secret . $signatureString . $secret));
        $signatureTmp = [];

        foreach ($signature as $key => $value) {
            if (!empty($data[$key])) {
                continue;
            } else {
                $signatureTmp[] = $key . ':' . $value;
            }
        }

        $this->signatureArray = array_merge($signatureTmp, ['signature:' . $signatureString]);

        return array_merge($signature, ['signature' => $signatureString]);
    }
}