<?php


namespace YiYunzhang;

use YiYunzhang\Common\Authentication;
use YiYunzhang\Request\RequestGateway;

/**
 * Class: Client
 * @describe: 请求客户端
 * @author: MagicConch17
 * @email: higanbana98@hotmail.com
 * @date: 2020/10/30 14:08
 * @package YiYunzhang
 */
class Client
{
    use Authentication;

    /**
     * @var string $host api address
     */
    public $host = '';

    /**
     * @var string $AppKey appkey
     */
    protected $AppKey = '';

    /**
     * @var string
     */
    protected $secret;

    /**
     * @var RequestGateway $Request
     */
    protected $Request;

    public function __set($name, $value)
    {
        $this->{$name} = $value;
        return $this;
    }

    public function __get($name)
    {
        return $this->{$name};
    }

    public function __construct($AppKey, $secret)
    {
        $this->AppKey = $AppKey;
        $this->secret = $secret;
        $this->instance();
    }

    public function instance()
    {
        $this->Request = new RequestGateway();
    }

    /**
     * Notes: 抽象 请求方法
     * @param $url
     * @param $method
     * @param $data
     * @param callable|null $function
     * @return bool|string
     * @date: 2020/10/30 14:47
     * @author: MagicConch17
     */
    public function quest($url, $method, $data = [], callable $function = null)
    {
        $data = $this->signature($this->AppKey, $this->secret, $data);
        $header = $this->signatureArray;
        return $this->Request->Quest($url, $header, $method, $data, true, $function);
    }

    /**
     * Notes: post 请求 json
     * @param $url
     * @param $data
     * @param callable|null $function
     * @return bool|string
     * @date: 2020/10/30 14:52
     * @author: MagicConch17
     */
    public function post($url, $data, callable $function = null)
    {
        return $this->quest($url, 'POST', $data, $function);
    }

    /**
     * Notes: get 请求
     * @param $url
     * @param callable|null $function
     * @return bool|string
     * @date: 2020/10/30 15:49
     * @author: MagicConch17
     */
    public function get($url, callable $function = null)
    {
        return $this->quest($url, 'GET', [], $function);
    }
}